# Python27 test script.
# This script executes a Python3 script using the subprocess module
import subprocess

try:
    # Open a subprocess pipe
    proc = subprocess.Popen(["python3", "am2315_py3.py"], stdin=None, stdout=subprocess.PIPE, stderr=subprocess.PIPE, universal_newlines=True) 
    # Read the data from the Python3 script
    outs, errs  = proc.communicate(input=None)
    # Strip out the \n
    outs = outs.strip('\n')
    # Split the sensor data into distinct fields to use as needed in your script
    data = outs.split(' ')
    # Print the data real pretty
    print 'The current temperature is %s.' % data[0]
    print 'The current humidity is %s.' % data[1]
except:
    # Un-oh...
    proc.kill()
    print 'Unable to read the sensor data.'

