/*---------------------------------------------------------------------------
sop4618_S_Demo.ino

Written by Sopwith
29 Sep 2014

Redistribution and use in source and binary forms, with or without
modification, is permitted. Use of this software for illegal or
malicious purposed is strictly prohibited. Attribution to the creator(s)
is appreciated but not required.

THIS SOFTWARE IS PROVIDED BY THE CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
------------------------------------------------------------------------------
 Arduino sketch that demonstrates the use of the sop4618_S C++ class.
------------------------------------------------------------------------------*/
#include <bv4618_S.h>
#include <BSerial.h>
#include "sop4618_S.h"
 
void Demo(sop4618_S& lcd);
void Kilroy(sop4618_S& lcd);
 
void setup() {
  // put your setup code here, to run once:
}

void loop() {
  // put your main code here, to run repeatedly:
  sop4618_S lcd(0, 1, 4, 20);  // Rx, Tx, lines, cols
  lcd.clearLCD();
  lcd.cursorShow(false);
 
  while(1)
	Demo(lcd);
}

void Kilroy(sop4618_S& lcd)
{
  lcd.clearLCD();
  lcd.centerString("Anybody seen Kilroy?", 2);
  delay(2000);
  lcd.clearLCD();
  lcd.centerString("-|||-", 1);
  lcd.centerString("(0 0)", 2);
  lcd.centerString("-ooO-( )-Ooo-", 3);
  lcd.cursorXY(4,1);
  lcd.printString("        (_)");
}

void Demo(sop4618_S& lcd)
{
  lcd.clearLCD();
  lcd.centerString("Hello World!", 2);
  lcd.clearLCD();
  lcd.centerString("ByVac BV4618 LCD", 1);
  lcd.centerString("Arduino C++ Class", 2);
  lcd.centerString("Sop4618_S", 3);
  lcd.centerString("Written by Sopwith", 4);
  delay(2000);
  lcd.clearLCD();
  lcd.centerString("LCD Information", 2);
  delay(2000);
  lcd.clearLCD();
  lcd.centerString("ByVac BV4618 LCD", 1);
  lcd.centerString("Version: " + lcd.getVersion(), 2);
  lcd.centerString("DeviceID: " + lcd.getDeviceID(), 3);
  lcd.centerString("Serial Connection", 4);
  delay(4000);
  Kilroy(lcd);
  delay(3000);
  lcd.clearLCD();
  lcd.centerString("Cursor is turned on", 2);
  lcd.cursorXY(3,10);
  lcd.cursorShow(true);
  delay(2000);
  lcd.centerString("Cursor is turned off", 2);
  lcd.cursorXY(3,10);
  lcd.cursorShow(false);
  delay(2000);
  lcd.clearLCD();
  lcd.centerString("Cursor blink is on", 2);
  lcd.cursorXY(3,10);
  lcd.cursorBlink(true);
  delay(2000);
  lcd.cursorBlink(false);
  lcd.centerString("Cursor blink is off", 2);
  lcd.cursorXY(3,10);
  lcd.cursorShow(false);
  lcd.clearLCD();
  lcd.cursorXY(2,1);
  lcd.printString("Scroll right");
  int x=9;
 
  while(x)
  {
    delay(750);
    lcd.displayShiftRight();
    x--;
  }
 
  lcd.clearLCD();
  lcd.cursorXY(2, 10);
  lcd.printString("Scroll left");
  x=9;
 
  while(x)
  {
    delay(750);
    lcd.displayShiftLeft();
    x--;
  }

  lcd.clearLCD();
  lcd.cursorXY(2,1);
  lcd.printString("Somebody is about to turn out the lights");
  delay(2000); 
  lcd.enableBacklight(false);
  lcd.clearLCD();
  lcd.cursorXY(2,1);
  lcd.centerString("It's dark in here!", 2);
  delay(2000); 
  lcd.centerString("Lights please?", 3);
  delay(2000);
  lcd.enableBacklight();
  lcd.clearLCD();
  lcd.centerString("Brownout is over...", 2);
  delay(2000);
  lcd.clearLCD();
  lcd.cursorShow(true);
  lcd.cursorBlink(true);
  lcd.centerString("Cursor is at 1,1",2);
  lcd.cursorXY(1,1);
  delay(2000);
  lcd.centerString("Cursor is at 1,20",2);
  lcd.cursorXY(1,20); 
  delay(2000);
  lcd.clearLCD();
  lcd.centerString("Cursor is at 4,1",2);
  lcd.cursorXY(4,1); 
  delay(2000);
  lcd.centerString("Cursor is at 4,20",2);
  lcd.cursorXY(4,20);
  delay(2000);
  lcd.clearLCD();
  lcd.cursorBlink(false);
  lcd.cursorShow(false);
  lcd.printString("Send bug reports, comments, and enhancement requests to sopwith@ismellsmoke.net"); 
  delay(5000);
}
