/*---------------------------------------------------------------------------
sop4618_S.h
Version 0.5

Written by Sopwith
29 Sep 2014

Redistribution and use in source and binary forms, with or without
modification, is permitted. Use of this software for illegal or
malicious purposed is strictly prohibited. Attribution to the creator(s)
is appreciated but not required.

THIS SOFTWARE IS PROVIDED BY THE CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
------------------------------------------------------------------------------
 Arduino C++ class that extends the capabilities of the ByVac 4618_S class.
 The datasheet for the device can be found here:
 http://www.byvac.co.uk/downloads/datasheets/BV4618%20Datasheet.pdf
------------------------------------------------------------------------------
 Revision history:
 	 Version 0.5
		2014-09-29 - Initial release
------------------------------------------------------------------------------*/
#include <Arduino.h>
#include <bv4618_S.h>

/** ByVac BV4618_S class extender.
    Arduino C++ class that provides a convenient wrapper for the BV4618 serial class.
	Derived from BV4618_S.
	Library dependencies:
		-# BV4618_S
		-# BSerial
*/
class sop4618_S : public BV4618_S
{
  public:
    // Constructors
	sop4618_S();
	sop4618_S(uint8_t rxPin, uint8_t txPin);
	sop4618_S(uint8_t rxPin, uint8_t txPin, uint8_t rows, uint8_t cols);
	
	// Getters
	uint8_t getRXPin();
    uint8_t getTXPin();
    uint8_t getNoRows();
    uint8_t getNoCols();
	
	// Public Methods
	void cursorShow(bool state=true);
	void enableBacklight(bool state=true);
	void cursorUp(uint8_t count=1);
	void cursorDown(uint8_t count=1);
	void cursorRight(uint8_t count=1);
	void cursorLeft(uint8_t count=1);
	void cursorHome();
	void cursorXY(uint8_t line, uint8_t col);
	void clearLCD();
	void cursorBS(uint8_t count);
	void cursorBlink(bool state=false);
	String getDeviceID();
	String getVersion();
	String readString();
	void printString(String s);
	void printStringXY(String s, int row, int col);
	void centerString(String str, int row);
	void setScreenSize(uint8_t rows, uint8_t cols);
	void displayShiftRight();
	void displayShiftLeft();
	void displaySetScroll(bool state=true);
	void sendCmd(uint8_t cmd);
	
	// private members
	uint8_t m_Rows;		///< No. of LCD lines
	uint8_t m_Cols;		///< No. of LCD columns
	uint8_t m_txPin;	///< Arduino Tx pin
	uint8_t m_rxPin;    ///< Arduin0 Rx pin
  
  protected:
    // protected methods
	void init(uint8_t rxPin, uint8_t txPin, uint8_t rows=4, uint8_t cols=20);
	void cursorMove(char dir, uint8_t count=1);
	bool gotACK();

};
